package com.hitachi.couriba.web.security;

import jakarta.servlet.http.HttpServletRequest;
import lombok.AllArgsConstructor;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;

/**
 * APIキーに基づく認証処理を提供するサービスクラス.
 * */
@AllArgsConstructor
public class SecurityAuthenticationService {

  private static final String AUTH_TOKEN_HEADER_NAME = "Api-key";

  private String authToken;
  private String errorMessage;

  public Authentication getAuthentication(HttpServletRequest request) {
    String apiKey = request.getHeader(AUTH_TOKEN_HEADER_NAME);
    if (apiKey == null || !isValidApiKey(apiKey, authToken)) {
      throw new BadCredentialsException(errorMessage);
    }

    return new ApiKeyAuthentication(apiKey, AuthorityUtils.NO_AUTHORITIES);
  }

  private boolean isValidApiKey(String apiKey, String expectedKeys) {
    String[] keys = expectedKeys.split(",");
    for (String key : keys) {
      if (apiKey.equals(key.trim())) {
        return true;
      }
    }
    return false;
  }
}